/*
 * Decompiled with CFR 0.152.
 */
package com.fizzware.dramaticdoors.forge.blocks;

import com.fizzware.dramaticdoors.forge.blocks.ShortDoorBlock;
import com.fizzware.dramaticdoors.forge.state.properties.DDBlockStateProperties;
import com.fizzware.dramaticdoors.forge.state.properties.Orientation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ShortFleshDoorBlock
extends ShortDoorBlock {
    public static final EnumProperty<Orientation> ORIENTATION = DDBlockStateProperties.ORIENTATION;
    public static final int USE_UPDATE_FLAG = 10;
    protected static final int THICKNESS = 2;
    protected static final int CLOSED_SHAPE_INDEX = 0;
    protected static final int OPEN_SHAPE_INDEX = 1;
    protected static final VoxelShape[] X_NEG_AABB = ShortFleshDoorBlock.createClosedAndOpenShape(0.0, 0.0, 0.0, 2.0, 16.0, 16.0);
    protected static final VoxelShape[] X_NONE_AABB = ShortFleshDoorBlock.createClosedAndOpenShape(7.0, 0.0, 0.0, 9.0, 16.0, 16.0);
    protected static final VoxelShape[] X_POS_AABB = ShortFleshDoorBlock.createClosedAndOpenShape(14.0, 0.0, 0.0, 16.0, 16.0, 16.0);
    protected static final VoxelShape[] Z_NEG_AABB = ShortFleshDoorBlock.createClosedAndOpenShape(0.0, 0.0, 0.0, 16.0, 16.0, 2.0);
    protected static final VoxelShape[] Z_NONE_AABB = ShortFleshDoorBlock.createClosedAndOpenShape(0.0, 0.0, 7.0, 16.0, 16.0, 9.0);
    protected static final VoxelShape[] Z_POS_AABB = ShortFleshDoorBlock.createClosedAndOpenShape(0.0, 0.0, 14.0, 16.0, 16.0, 16.0);

    public ShortFleshDoorBlock(Block from) {
        super(from);
        this.m_49959_((BlockState)this.m_49966_().m_61124_(ORIENTATION, (Comparable)((Object)Orientation.X_MIDDLE)));
    }

    private static VoxelShape[] createClosedAndOpenShape(double x0, double y0, double z0, double x1, double y1, double z1) {
        VoxelShape closedShape = Block.m_49796_((double)x0, (double)y0, (double)z0, (double)x1, (double)y1, (double)z1);
        boolean caseX = x0 == 0.0 && x1 == 16.0;
        boolean caseZ = z0 == 0.0 && z1 == 16.0;
        double offset = 2.0;
        double xA = caseX ? x0 + offset : x0;
        double zA = caseZ ? z0 + offset : z0;
        double xB = caseX ? x1 - offset : x1;
        double zB = caseZ ? z1 - offset : z1;
        VoxelShape openShape = Shapes.m_83113_((VoxelShape)closedShape, (VoxelShape)Block.m_49796_((double)xA, (double)(y0 + offset), (double)zA, (double)xB, (double)(y1 - offset), (double)zB), (BooleanOp)BooleanOp.f_82687_);
        VoxelShape openShapeForCollision = Shapes.m_83113_((VoxelShape)closedShape, (VoxelShape)Block.m_49796_((double)xA, (double)y0, (double)zA, (double)xB, (double)y1, (double)zB), (BooleanOp)BooleanOp.f_82687_);
        return new VoxelShape[]{closedShape, openShape, openShapeForCollision};
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        Level level = context.m_43725_();
        if (pos.m_123342_() >= level.m_151558_() || !level.m_8055_(pos).m_60629_(context)) {
            return null;
        }
        BlockState state = this.m_49966_();
        if (!context.m_7058_()) {
            Orientation orientation = Orientation.getXZOrientationFrom(context);
            state = (BlockState)state.m_61124_(ORIENTATION, (Comparable)((Object)orientation));
        } else {
            boolean isXAxis = context.m_8125_().m_122434_() == Direction.Axis.X;
            state = (BlockState)state.m_61124_(ORIENTATION, (Comparable)((Object)(isXAxis ? Orientation.X_MIDDLE : Orientation.Z_MIDDLE)));
        }
        if (level.m_46753_(pos) || level.m_46753_(pos.m_7494_())) {
            state = (BlockState)((BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(true))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(true));
        }
        if (context.m_8125_().m_122434_() == Direction.Axis.X) {
            state = (BlockState)state.m_61124_((Property)FACING, (Comparable)Direction.EAST);
        } else if (context.m_8125_().m_122434_() == Direction.Axis.Z) {
            state = (BlockState)state.m_61124_((Property)FACING, (Comparable)Direction.NORTH);
        }
        state = (BlockState)state.m_61124_((Property)HINGE, (Comparable)this.getHinge(context));
        if (context.m_8125_() == Direction.WEST || context.m_8125_() == Direction.SOUTH) {
            state = (BlockState)state.m_61122_((Property)HINGE);
        }
        if (level.m_6425_(pos).m_76152_() == Fluids.f_76193_) {
            state = (BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    @Override
    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(level, pos, state, placer, stack);
    }

    @Override
    protected DoorHingeSide getHinge(BlockPlaceContext pContext) {
        return super.getHinge(pContext);
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        int offset = 0;
        int idx = this.isOpen(state) ? 1 + offset : 0;
        return switch ((Orientation)((Object)state.m_61143_(ORIENTATION))) {
            case Orientation.X_POSITIVE -> X_POS_AABB[idx];
            case Orientation.X_MIDDLE -> X_NONE_AABB[idx];
            case Orientation.X_NEGATIVE -> X_NEG_AABB[idx];
            case Orientation.Z_POSITIVE -> Z_POS_AABB[idx];
            case Orientation.Z_MIDDLE -> Z_NONE_AABB[idx];
            case Orientation.Z_NEGATIVE -> Z_NEG_AABB[idx];
            default -> Shapes.m_83144_();
        };
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        int idx = this.isOpen(state) ? 2 : 0;
        return switch ((Orientation)((Object)state.m_61143_(ORIENTATION))) {
            case Orientation.X_POSITIVE -> X_POS_AABB[idx];
            case Orientation.X_MIDDLE -> X_NONE_AABB[idx];
            case Orientation.X_NEGATIVE -> X_NEG_AABB[idx];
            case Orientation.Z_POSITIVE -> Z_POS_AABB[idx];
            case Orientation.Z_MIDDLE -> Z_NONE_AABB[idx];
            case Orientation.Z_NEGATIVE -> Z_NEG_AABB[idx];
            default -> Shapes.m_83144_();
        };
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case PathComputationType.LAND, PathComputationType.AIR -> this.isOpen(state);
            case PathComputationType.WATER -> false;
        };
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{ORIENTATION});
    }

    @Override
    public BlockState m_6843_(BlockState state, Rotation rotationDirection) {
        Orientation orientation = (Orientation)((Object)state.m_61143_(ORIENTATION));
        return (BlockState)state.m_61124_(ORIENTATION, (Comparable)((Object)orientation.rotate(rotationDirection)));
    }

    @Override
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        Orientation orientation = (Orientation)((Object)state.m_61143_(ORIENTATION));
        return (BlockState)state.m_61124_(ORIENTATION, (Comparable)((Object)orientation.mirror(mirror)));
    }
}

